<?php
/**
 * Diagnose-Tool für URL-Probleme
 * Zugriff: Muss über WordPress geladen werden
 */

// WordPress laden
require_once dirname(__FILE__) . '/../../../wp-load.php';

global $wpdb;

header('Content-Type: application/json');

$result = [];

// 1. Aktuelle URLs
$result['site_url'] = get_option('siteurl');
$result['home_url'] = get_option('home');

// 2. Prüfe ob alte URLs noch in Posts vorhanden sind
$old_urls = ['pixel-report.com', 'https://pixel-report.com', 'http://pixel-report.com'];

foreach ($old_urls as $old_url) {
    $count_posts = $wpdb->get_var($wpdb->prepare(
        "SELECT COUNT(*) FROM {$wpdb->posts} WHERE post_content LIKE %s",
        '%' . $wpdb->esc_like($old_url) . '%'
    ));
    $count_guid = $wpdb->get_var($wpdb->prepare(
        "SELECT COUNT(*) FROM {$wpdb->posts} WHERE guid LIKE %s",
        '%' . $wpdb->esc_like($old_url) . '%'
    ));
    $count_postmeta = $wpdb->get_var($wpdb->prepare(
        "SELECT COUNT(*) FROM {$wpdb->postmeta} WHERE meta_value LIKE %s",
        '%' . $wpdb->esc_like($old_url) . '%'
    ));
    
    $result['old_url_occurrences'][$old_url] = [
        'in_post_content' => (int)$count_posts,
        'in_guid' => (int)$count_guid,
        'in_postmeta' => (int)$count_postmeta,
    ];
}

// 3. Prüfe bricks_global_classes
$gc = get_option('bricks_global_classes');
$result['bricks_global_classes'] = [
    'type' => gettype($gc),
    'count' => is_array($gc) ? count($gc) : 'N/A',
    'is_empty' => empty($gc),
];

// 4. Sample Post URLs
$sample_posts = $wpdb->get_results(
    "SELECT ID, post_title, guid FROM {$wpdb->posts} WHERE post_type = 'post' AND post_status = 'publish' LIMIT 3",
    ARRAY_A
);
$result['sample_posts'] = $sample_posts;

// 5. Sample Post Content (erste 200 Zeichen)
$sample_content = $wpdb->get_var(
    "SELECT post_content FROM {$wpdb->posts} WHERE post_type = 'post' AND post_status = 'publish' LIMIT 1"
);
$result['sample_content_start'] = substr($sample_content, 0, 300);

// Ausgabe
echo json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);

