<?php
if (!defined('ABSPATH')) {
    exit;
}

$settings = get_option('jbm_settings', [
    'max_full_backups' => 10,
    'max_database_backups' => 30,
    'max_other_backups' => 20,
    'compression_level' => 6,
    'backup_speed' => 'medium',
    'email_notifications' => false,
    'email_address' => get_option('admin_email'),
    'show_diagnose_tool' => false,
    'show_cron_debug' => false,
]);

// Automatisches Update auf neue Standardwerte
$needs_update = false;
if (!isset($settings['max_full_backups'])) {
    $settings['max_full_backups'] = 10;
    $needs_update = true;
}
if (!isset($settings['max_database_backups'])) {
    $settings['max_database_backups'] = 30;
    $needs_update = true;
}
if (!isset($settings['max_other_backups'])) {
    $settings['max_other_backups'] = 20;
    $needs_update = true;
}
if (!isset($settings['show_diagnose_tool'])) {
    $settings['show_diagnose_tool'] = false;
    $needs_update = true;
}
if (!isset($settings['show_cron_debug'])) {
    $settings['show_cron_debug'] = false;
    $needs_update = true;
}
// Migration: alte max_partial_backups umwandeln
if (isset($settings['max_partial_backups'])) {
    if (!isset($settings['max_database_backups'])) {
        $settings['max_database_backups'] = $settings['max_partial_backups'];
    }
    if (!isset($settings['max_other_backups'])) {
        $settings['max_other_backups'] = intval($settings['max_partial_backups'] / 2);
    }
    unset($settings['max_partial_backups']);
    $needs_update = true;
}
if ($needs_update) {
    update_option('jbm_settings', $settings);
}

if (isset($_POST['jbm_save_settings']) && check_admin_referer('jbm_settings_nonce')) {
    $settings = [
        'max_full_backups' => intval($_POST['max_full_backups']),
        'max_database_backups' => intval($_POST['max_database_backups']),
        'max_other_backups' => intval($_POST['max_other_backups']),
        'compression_level' => 6, // Fest optimiert
        'backup_speed' => 'medium', // Fest optimiert
        'email_notifications' => isset($_POST['email_notifications']),
        'email_address' => sanitize_email($_POST['email_address']),
        'show_diagnose_tool' => isset($_POST['show_diagnose_tool']),
        'show_cron_debug' => isset($_POST['show_cron_debug']),
    ];
    
    update_option('jbm_settings', $settings);
    
    echo '<div class="bmp-alert bmp-alert-success">';
    echo '<span class="dashicons dashicons-yes"></span>';
    echo '<div>';
    echo __('Einstellungen gespeichert', 'jenva-backup-migration') . '<br>';
    echo '<small style="opacity: 0.8; line-height: 1.8;">';
    echo esc_html(__('Vollständige:', 'jenva-backup-migration') . ' ' . intval($settings['max_full_backups'])) . ' | ';
    echo esc_html(__('Datenbank:', 'jenva-backup-migration') . ' ' . intval($settings['max_database_backups'])) . ' | ';
    echo esc_html(__('Andere:', 'jenva-backup-migration') . ' ' . intval($settings['max_other_backups']));
    echo '</small>';
    echo '</div>';
    echo '</div>';
}

$logger = new \JBM\Logger();
$logs = $logger->get_logs(50);
?>

<div class="bmp-container">
    <div class="bmp-header">
        <h1>
            <span class="dashicons dashicons-admin-settings"></span>
            <?php _e('Einstellungen', 'jenva-backup-migration'); ?>
        </h1>
        <p class="bmp-subtitle"><?php _e('Konfigurieren Sie Jenva Backup & Migration', 'jenva-backup-migration'); ?></p>
    </div>

    <div class="bmp-card">
        <div class="bmp-card-header">
            <h2><?php _e('Allgemeine Einstellungen', 'jenva-backup-migration'); ?></h2>
        </div>
        <div class="bmp-card-body">
            <form method="post">
                <?php wp_nonce_field('jbm_settings_nonce'); ?>
                
                <div class="bmp-form-group">
                    <label for="max-full-backups">
                        <?php _e('💾 Maximale vollständige Backups', 'jenva-backup-migration'); ?>
                    </label>
                    <input type="number" id="max-full-backups" name="max_full_backups" value="<?php echo esc_attr($settings['max_full_backups'] ?? 10); ?>" min="1" max="100" class="bmp-input" style="max-width: 150px;">
                    <p class="bmp-form-help"><?php _e('Vollständige Backups (DB + alle Dateien). Benötigen viel Speicherplatz.', 'jenva-backup-migration'); ?></p>
                </div>

                <div class="bmp-form-group">
                    <label for="max-database-backups">
                        <?php _e('🗄️ Maximale Datenbank-Backups', 'jenva-backup-migration'); ?>
                    </label>
                    <input type="number" id="max-database-backups" name="max_database_backups" value="<?php echo esc_attr($settings['max_database_backups'] ?? 30); ?>" min="1" max="200" class="bmp-input" style="max-width: 150px;">
                    <p class="bmp-form-help"><?php _e('Nur Datenbank-Backups. Klein und schnell, ideal für tägliche Backups.', 'jenva-backup-migration'); ?></p>
                </div>

                <div class="bmp-form-group">
                    <label for="max-other-backups">
                        <?php _e('📁 Maximale andere Backups', 'jenva-backup-migration'); ?>
                    </label>
                    <input type="number" id="max-other-backups" name="max_other_backups" value="<?php echo esc_attr($settings['max_other_backups'] ?? 20); ?>" min="1" max="200" class="bmp-input" style="max-width: 150px;">
                    <p class="bmp-form-help"><?php _e('Plugins, Themes, Uploads, Content-Backups. Mittelgroß.', 'jenva-backup-migration'); ?></p>
                </div>
                
                <div style="margin: 15px 0; padding: 15px; background: #d4edda; border-left: 4px solid #28a745; border-radius: 4px;">
                    <strong style="color: #155724; font-size: 14px;"><?php _e('✅ Wie funktioniert die automatische Bereinigung?', 'jenva-backup-migration'); ?></strong>
                    <div style="margin: 12px 0 0 0; color: #155724; font-size: 13px; line-height: 1.8;">
                        <p style="margin: 0 0 8px 0;">
                            <?php echo sprintf(__('Die Limits gelten <strong>pro Kategorie STRIKT SEPARAT</strong>:', 'jenva-backup-migration')); ?>
                        </p>
                        <ul style="margin: 0 0 12px 20px;">
                            <li><strong><?php _e('💾 Vollständig:', 'jenva-backup-migration'); ?></strong> <?php _e('Nur "Full" Backups (DB + alle Dateien)', 'jenva-backup-migration'); ?></li>
                            <li><strong><?php _e('🗄️ Datenbank:', 'jenva-backup-migration'); ?></strong> <?php _e('Nur "Database" Backups', 'jenva-backup-migration'); ?></li>
                            <li><strong><?php _e('📁 Andere:', 'jenva-backup-migration'); ?></strong> <?php _e('Files, Plugins, Themes, Uploads', 'jenva-backup-migration'); ?></li>
                        </ul>
                        <p style="margin: 0 0 8px 0; padding: 8px; background: rgba(255,255,255,0.5); border-radius: 4px;">
                            <?php echo sprintf(__('<strong>Beispiel:</strong> Limit "Datenbank: 5" → Bei 6 DB-Backups wird das <strong>älteste DB-Backup</strong> gelöscht.<br>Full-Backups und Andere bleiben davon <strong>unberührt</strong>!', 'jenva-backup-migration')); ?>
                        </p>
                        <p style="margin: 0; padding: 8px; background: rgba(255,255,255,0.5); border-radius: 4px;">
                            <?php _e('🔒 <strong>Geschützte Backups</strong> zählen NICHT zum Limit und bleiben immer!', 'jenva-backup-migration'); ?><br>
                            <?php _e('📤 <strong>Hochgeladene Backups</strong> werden NICHT automatisch bereinigt.', 'jenva-backup-migration'); ?>
                        </p>
                    </div>
                    <button type="button" id="jbm-manual-cleanup" class="bmp-button bmp-button-secondary" style="margin-top: 12px;">
                        <span class="dashicons dashicons-trash"></span>
                        <?php _e('Bereinigung jetzt manuell ausführen', 'jenva-backup-migration'); ?>
                    </button>
                    <p class="description" style="margin-top: 8px; font-style: italic; color: #666;">
                        <?php _e('Löscht alte Backups basierend auf den oben eingestellten Limits. Die Bereinigung läuft auch automatisch nach jeder Backup-Erstellung. Geschützte Backups werden niemals gelöscht.', 'jenva-backup-migration'); ?>
                    </p>
                </div>
                
                <!-- Cleanup Modal -->
                <div id="jbm-cleanup-modal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.6); z-index: 999999; justify-content: center; align-items: center;">
                    <div style="background: white; padding: 30px; border-radius: 12px; max-width: 450px; width: 90%; box-shadow: 0 10px 40px rgba(0,0,0,0.3); text-align: center;">
                        <div style="font-size: 48px; margin-bottom: 40px;">🗑️</div>
                        <h3 id="jbm-cleanup-modal-title" style="margin: 0 0 15px 0; font-size: 20px; color: #1d2327;">
                            <?php _e('Alte Backups bereinigen?', 'jenva-backup-migration'); ?>
                        </h3>
                        <p id="jbm-cleanup-modal-message" style="margin: 0 0 15px 0; color: #666; line-height: 1.6;">
                            <?php _e('Alte Backups werden basierend auf den eingestellten Limits gelöscht. Geschützte Backups bleiben erhalten.', 'jenva-backup-migration'); ?>
                        </p>
                        <p style="margin: 0 0 20px 0; padding: 10px; background: #fff3cd; border-radius: 6px; color: #856404; font-weight: 500;">
                            <?php _e('⚠️ WARNUNG: Gelöschte Backups können nicht wiederhergestellt werden!', 'jenva-backup-migration'); ?>
                        </p>
                        <div style="display: flex; gap: 12px; justify-content: center;">
                            <button type="button" id="jbm-cleanup-modal-cancel" class="button button-secondary" style="padding: 8px 20px;">
                                <span class="cancel-text"><?php _e('Abbrechen', 'jenva-backup-migration'); ?></span>
                            </button>
                            <button type="button" id="jbm-cleanup-modal-confirm" class="button button-primary" style="padding: 8px 20px; background: #d63638; border-color: #d63638;">
                                <span class="confirm-text"><?php _e('Bereinigen', 'jenva-backup-migration'); ?></span>
                            </button>
                        </div>
                    </div>
                </div>

                <script>
                jQuery(document).ready(function($) {
                    $('#jbm-manual-cleanup').on('click', function() {
                        // Modal anzeigen
                        $('#jbm-cleanup-modal').css('display', 'flex');
                    });
                    
                    // Abbrechen
                    $('#jbm-cleanup-modal-cancel').on('click', function() {
                        $('#jbm-cleanup-modal').css('display', 'none');
                    });
                    
                    // Bestätigen
                    $('#jbm-cleanup-modal-confirm').on('click', function() {
                        $('#jbm-cleanup-modal').css('display', 'none');
                        
                        const button = $('#jbm-manual-cleanup');
                        const originalHtml = button.html();
                        button.prop('disabled', true).html('<span class="dashicons dashicons-update spin"></span> <?php echo esc_js(__('Bereinige...', 'jenva-backup-migration')); ?>');
                        
                        $.ajax({
                            url: '<?php echo admin_url('admin-ajax.php'); ?>',
                            type: 'POST',
                            data: {
                                action: 'jbm_cleanup_old_backups',
                                nonce: '<?php echo wp_create_nonce('jbm_nonce'); ?>'
                            },
                            success: function(response) {
                                if (response.success) {
                                    button.html('<span class="dashicons dashicons-yes"></span> ' + response.data.message);
                                    setTimeout(function() {
                                        location.reload();
                                    }, 1500);
                                } else {
                                    alert('❌ <?php echo esc_js(__('Fehler:', 'jenva-backup-migration')); ?> ' + (response.data.message || '<?php echo esc_js(__('Unbekannt', 'jenva-backup-migration')); ?>'));
                                    button.prop('disabled', false).html(originalHtml);
                                }
                            },
                            error: function() {
                                alert('❌ <?php echo esc_js(__('Fehler beim Bereinigen', 'jenva-backup-migration')); ?>');
                                button.prop('disabled', false).html(originalHtml);
                            }
                        });
                    });
                    
                    // Modal schließen bei Klick außerhalb
                    $('#jbm-cleanup-modal').on('click', function(e) {
                        if (e.target === this) {
                            $(this).css('display', 'none');
                        }
                    });
                });
                </script>

                <!-- Versteckte Felder für optimale Performance (nicht sichtbar für User) -->
                <input type="hidden" name="compression_level" value="6">
                <input type="hidden" name="backup_speed" value="medium">

                <div class="bmp-form-group">
                    <label class="bmp-toggle-label">
                        <input type="checkbox" id="email-notifications" name="email_notifications" <?php checked($settings['email_notifications'], true); ?>>
                        <span class="bmp-toggle-slider"></span>
                        <?php _e('E-Mail-Benachrichtigungen aktivieren', 'jenva-backup-migration'); ?>
                    </label>
                </div>

                <div class="bmp-form-group" id="email-address-group" style="<?php echo $settings['email_notifications'] ? '' : 'display: none;'; ?>">
                    <label for="email-address"><?php _e('E-Mail-Adresse', 'jenva-backup-migration'); ?></label>
                    <input type="email" id="email-address" name="email_address" value="<?php echo esc_attr($settings['email_address']); ?>" class="bmp-input">
                    <p class="bmp-form-help"><?php _e('Erhalten Sie Benachrichtigungen über erfolgreiche und fehlgeschlagene Backups.', 'jenva-backup-migration'); ?></p>
                </div>

                <div class="bmp-form-group">
                    <label class="bmp-toggle-label">
                        <input type="checkbox" id="show-diagnose-tool" name="show_diagnose_tool" <?php checked($settings['show_diagnose_tool'] ?? false, true); ?>>
                        <span class="bmp-toggle-slider"></span>
                        <?php _e('Diagnose-Tool anzeigen', 'jenva-backup-migration'); ?>
                    </label>
                    <p class="bmp-form-help"><?php _e('Zeigt das Diagnose-Tool auf der Hauptseite an, um Probleme beim Anzeigen von Backups zu diagnostizieren.', 'jenva-backup-migration'); ?></p>
                </div>

                <div class="bmp-form-group">
                    <label class="bmp-toggle-label">
                        <input type="checkbox" id="show-cron-debug" name="show_cron_debug" <?php checked($settings['show_cron_debug'] ?? false, true); ?>>
                        <span class="bmp-toggle-slider"></span>
                        <?php _e('Cron-Status & Debugging anzeigen', 'jenva-backup-migration'); ?>
                    </label>
                    <p class="bmp-form-help"><?php _e('Zeigt den Cron-Status & Debugging-Bereich auf der Zeitplan-Seite an, um geplante Backups zu überwachen und zu testen.', 'jenva-backup-migration'); ?></p>
                </div>

                <div class="bmp-form-actions">
                    <button type="submit" name="jbm_save_settings" class="bmp-button bmp-button-primary">
                        <span class="dashicons dashicons-saved"></span>
                        <?php _e('Einstellungen speichern', 'jenva-backup-migration'); ?>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- System-Informationen -->
    <div class="bmp-card">
        <div class="bmp-card-header">
            <h2><?php _e('System-Informationen', 'jenva-backup-migration'); ?></h2>
        </div>
        <div class="bmp-card-body">
            <div class="bmp-info-grid">
                <div class="bmp-info-item">
                    <strong><?php _e('WordPress-Version:', 'jenva-backup-migration'); ?></strong>
                    <span><?php echo get_bloginfo('version'); ?></span>
                </div>
                <div class="bmp-info-item">
                    <strong><?php _e('PHP-Version:', 'jenva-backup-migration'); ?></strong>
                    <span><?php echo PHP_VERSION; ?></span>
                </div>
                <div class="bmp-info-item">
                    <strong><?php _e('MySQL-Version:', 'jenva-backup-migration'); ?></strong>
                    <span><?php echo $GLOBALS['wpdb']->db_version(); ?></span>
                </div>
                <div class="bmp-info-item">
                    <strong><?php _e('Server:', 'jenva-backup-migration'); ?></strong>
                    <span><?php echo esc_html($_SERVER['SERVER_SOFTWARE'] ?? 'Unknown'); ?></span>
                </div>
                <div class="bmp-info-item">
                    <strong><?php _e('Memory Limit:', 'jenva-backup-migration'); ?></strong>
                    <span><?php echo ini_get('memory_limit'); ?></span>
                </div>
                <div class="bmp-info-item">
                    <strong><?php _e('Max Upload:', 'jenva-backup-migration'); ?></strong>
                    <span><?php echo ini_get('upload_max_filesize'); ?></span>
                </div>
                <div class="bmp-info-item">
                    <strong><?php _e('ZipArchive:', 'jenva-backup-migration'); ?></strong>
                    <span class="<?php echo class_exists('ZipArchive') ? 'bmp-status-success' : 'bmp-status-error'; ?>">
                        <?php echo class_exists('ZipArchive') ? __('Verfügbar', 'jenva-backup-migration') : __('Nicht verfügbar', 'jenva-backup-migration'); ?>
                    </span>
                </div>
                <div class="bmp-info-item">
                    <strong><?php _e('Backup-Verzeichnis:', 'jenva-backup-migration'); ?></strong>
                    <span class="<?php echo is_writable(JBM_BACKUP_DIR) ? 'bmp-status-success' : 'bmp-status-error'; ?>">
                        <?php echo is_writable(JBM_BACKUP_DIR) ? __('Beschreibbar', 'jenva-backup-migration') : __('Nicht beschreibbar', 'jenva-backup-migration'); ?>
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Nginx/Server-Sicherheit - Nur bei wirklich erkanntem Nginx und als ausklappbarer Bereich -->
    <?php 
    // Prüfe ob vermutlich Nginx läuft (nur wenn wirklich Nginx erkannt wird)
    $server_software = $_SERVER['SERVER_SOFTWARE'] ?? '';
    $is_nginx = (stripos($server_software, 'nginx') !== false);
    
    // Nur anzeigen wenn wirklich Nginx erkannt wurde (nicht bei allen Nicht-Apache Servern)
    if ($is_nginx):
        // Prüfe ob User diese Info bereits ausgeblendet hat
        $hide_nginx_info = get_option('jbm_hide_nginx_info', false);
    ?>
    <?php if (!$hide_nginx_info): ?>
    <div class="bmp-card" style="border-left: 4px solid #2271b1;">
        <div class="bmp-card-header" style="cursor: pointer;" onclick="jQuery(this).next().slideToggle(); jQuery(this).find('.dashicons').toggleClass('dashicons-arrow-down-alt2 dashicons-arrow-up-alt2');">
            <h2 style="color: #2271b1; margin: 0; display: flex; align-items: center; justify-content: space-between;">
                <span>
                    <span class="dashicons dashicons-info"></span>
                    <?php _e('ℹ️ Erweiterte Server-Konfiguration (Optional)', 'jenva-backup-migration'); ?>
                </span>
                <span class="dashicons dashicons-arrow-down-alt2" style="font-size: 20px; transition: transform 0.3s;"></span>
            </h2>
        </div>
        <div class="bmp-card-body" style="display: none;">
            <div style="background: #e7f3ff; padding: 15px; border-radius: 8px; margin-bottom: 15px; border-left: 4px solid #2271b1;">
                <strong style="color: #005177;">ℹ️ <?php _e('Nginx erkannt', 'jenva-backup-migration'); ?></strong>
                <p style="margin: 10px 0 0 0; color: #005177; font-size: 14px;">
                    <?php _e('Nginx ignoriert .htaccess-Dateien. Das Plugin erstellt bereits .htaccess-Dateien für Apache-Kompatibilität. Für optimale Sicherheit auf Nginx-Servern können Sie optional diese Konfiguration hinzufügen:', 'jenva-backup-migration'); ?>
                </p>
            </div>
            
            <div style="background: #1e1e1e; border-radius: 8px; padding: 15px; margin-bottom: 15px; overflow-x: auto;">
                <pre style="color: #d4d4d4; margin: 0; font-family: 'Fira Code', 'Monaco', 'Consolas', monospace; font-size: 12px; line-height: 1.6;"><code><span style="color: #608b4e;"># Jenva Backup & Migration - Sicherheitskonfiguration für Nginx</span>
<span style="color: #608b4e;"># Fügen Sie dies in Ihren server {} Block ein</span>

<span style="color: #569cd6;">location</span> ~* <span style="color: #ce9178;">/wp-content/jenva-backup-migration/.*\.(log|txt|json|sql|php|phtml|phar)$</span> {
    <span style="color: #569cd6;">deny</span> all;
    <span style="color: #569cd6;">return</span> <span style="color: #b5cea8;">403</span>;
}

<span style="color: #608b4e;"># Erlaube nur ZIP-Downloads</span>
<span style="color: #569cd6;">location</span> ~* <span style="color: #ce9178;">/wp-content/jenva-backup-migration/.*\.zip$</span> {
    <span style="color: #569cd6;">allow</span> all;
}</code></pre>
            </div>
            
            <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                <button type="button" class="bmp-button bmp-button-secondary" onclick="navigator.clipboard.writeText(`# Jenva Backup & Migration - Nginx Security
location ~* /wp-content/jenva-backup-migration/.*\\.(log|txt|json|sql|php|phtml|phar)$ {
    deny all;
    return 403;
}
location ~* /wp-content/jenva-backup-migration/.*\\.zip$ {
    allow all;
}`); this.innerHTML='<span class=\'dashicons dashicons-yes\'></span> <?php echo esc_js(__('Kopiert!', 'jenva-backup-migration')); ?>'; setTimeout(() => { this.innerHTML='<span class=\'dashicons dashicons-clipboard\'></span> <?php echo esc_js(__('In Zwischenablage kopieren', 'jenva-backup-migration')); ?>'; }, 2000);">
                    <span class="dashicons dashicons-clipboard"></span>
                    <?php _e('In Zwischenablage kopieren', 'jenva-backup-migration'); ?>
                </button>
                
                <button type="button" class="bmp-button bmp-button-secondary" onclick="jQuery.post(ajaxurl, {action: 'jbm_hide_nginx_info', nonce: '<?php echo wp_create_nonce('jbm_nonce'); ?>'}, function() { jQuery(this).closest('.bmp-card').fadeOut(); }.bind(this));">
                    <span class="dashicons dashicons-dismiss"></span>
                    <?php _e('Nicht mehr anzeigen', 'jenva-backup-migration'); ?>
                </button>
            </div>
            
            <div style="margin-top: 15px; padding: 12px; background: #f8f9fa; border-radius: 6px; font-size: 13px; color: #666;">
                <strong><?php _e('Hinweis:', 'jenva-backup-migration'); ?></strong>
                <?php _e('Nach dem Hinzufügen der Konfiguration starten Sie Nginx neu mit:', 'jenva-backup-migration'); ?>
                <code style="background: #e9ecef; padding: 2px 6px; border-radius: 3px; margin-left: 5px;">sudo nginx -t && sudo systemctl reload nginx</code>
            </div>
        </div>
    </div>
    <?php endif; ?>
    <?php endif; ?>

    <!-- Logs -->
    <div class="bmp-card">
        <div class="bmp-card-header">
            <h2><?php _e('Aktivitätsprotokoll', 'jenva-backup-migration'); ?></h2>
            <button class="bmp-button bmp-button-secondary" id="jbm-clear-logs">
                <span class="dashicons dashicons-trash"></span>
                <?php _e('Logs löschen', 'jenva-backup-migration'); ?>
            </button>
        </div>
        <div class="bmp-card-body">
            <?php if (empty($logs)): ?>
                <div class="bmp-empty-state">
                    <span class="dashicons dashicons-media-text"></span>
                    <h3><?php _e('Keine Logs vorhanden', 'jenva-backup-migration'); ?></h3>
                </div>
            <?php else: ?>
                <div class="bmp-logs-container">
                    <?php foreach ($logs as $log): ?>
                        <?php if (!empty(trim($log))): ?>
                            <div class="bmp-log-entry"><?php echo esc_html($log); ?></div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Clear Logs Confirmation Modal -->
<div id="jbm-clear-logs-modal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.7); z-index: 100000; align-items: center; justify-content: center;">
    <div style="background: white; border-radius: 12px; padding: 30px; max-width: 500px; width: 90%; box-shadow: 0 8px 32px rgba(0,0,0,0.3); position: relative; text-align: center;">
        <div style="margin-bottom: 20px;">
            <div style="font-size: 48px; margin-bottom: 30px;">🗑️</div>
            <h2 id="jbm-clear-logs-modal-title" style="margin: 0 0 15px 0; color: #d63638; font-size: 22px;"></h2>
        </div>
        <div style="margin-bottom: 25px;">
            <p id="jbm-clear-logs-modal-message" style="margin: 0; font-size: 15px; line-height: 1.6; color: #1d2327;"></p>
        </div>
        <div style="display: flex; gap: 10px; justify-content: center;">
            <button id="jbm-clear-logs-modal-cancel" class="bmp-button bmp-button-secondary" style="min-width: 120px;">
                <span class="dashicons dashicons-no"></span>
                <span class="cancel-text"></span>
            </button>
            <button id="jbm-clear-logs-modal-confirm" class="bmp-button bmp-button-danger" style="min-width: 120px;">
                <span class="dashicons dashicons-trash"></span>
                <span class="confirm-text"></span>
            </button>
        </div>
    </div>
</div>

