<?php
if (!defined('ABSPATH')) {
    exit;
}

// Einstellungen laden
$settings = get_option('jbm_settings', [
    'show_cron_debug' => false,
]);
$show_cron_debug = $settings['show_cron_debug'] ?? false;

// Zwei separate Zeitpläne
$schedule_1 = get_option('jbm_schedule_1', [
    'enabled' => false,
    'frequency' => 'weekly',
    'time' => '02:00',
    'weekday' => '1', // Montag
    'monthday' => '1',
    'backup_type' => 'database',
]);

$schedule_2 = get_option('jbm_schedule_2', [
    'enabled' => false,
    'frequency' => 'weekly',
    'time' => '03:00',
    'weekday' => '0', // Sonntag
    'monthday' => '1',
    'backup_type' => 'full',
]);

$next_scheduled_1 = wp_next_scheduled('jbm_scheduled_backup_1');
$next_scheduled_2 = wp_next_scheduled('jbm_scheduled_backup_2');
?>

<div class="bmp-container">
    <div class="bmp-header">
        <h1>
            <span class="dashicons dashicons-clock"></span>
            <?php _e('Geplante Backups', 'jenva-backup-migration'); ?>
        </h1>
        <p class="bmp-subtitle"><?php _e('Automatische Backups nach Zeitplan - Bis zu 2 verschiedene Zeitpläne möglich', 'jenva-backup-migration'); ?></p>
    </div>

    <!-- Info-Box für nächste geplante Backups -->
    <?php if ($next_scheduled_1 || $next_scheduled_2): ?>
        <div class="bmp-alert bmp-alert-info">
            <span class="dashicons dashicons-info"></span>
            <div>
                <strong><?php _e('Nächste geplante Backups:', 'jenva-backup-migration'); ?></strong><br>
                <?php if ($next_scheduled_1): ?>
                    <span style="display: inline-block; margin: 5px 10px 5px 0; padding: 4px 10px; background: #2271b1; color: white; border-radius: 3px; font-size: 13px;">
                        <?php echo sprintf(__('📅 Zeitplan 1: %s', 'jenva-backup-migration'), date_i18n(get_option('date_format') . ' ' . get_option('time_format'), $next_scheduled_1)); ?>
                    </span>
                <?php endif; ?>
                <?php if ($next_scheduled_2): ?>
                    <span style="display: inline-block; margin: 5px 10px 5px 0; padding: 4px 10px; background: #00a32a; color: white; border-radius: 3px; font-size: 13px;">
                        <?php echo sprintf(__('📅 Zeitplan 2: %s', 'jenva-backup-migration'), date_i18n(get_option('date_format') . ' ' . get_option('time_format'), $next_scheduled_2)); ?>
                    </span>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>

    <!-- Zeitplan 1 -->
    <div class="bmp-card">
        <div class="bmp-card-header" style="background: linear-gradient(135deg, #2271b1, #72aee6);">
            <h2 style="color: white;">
                <span class="dashicons dashicons-clock" style="color: white;"></span>
                <?php _e('Zeitplan 1 - z.B. Tägliche Datenbank-Backups', 'jenva-backup-migration'); ?>
            </h2>
        </div>
        <div class="bmp-card-body">
            <form id="jbm-schedule-form-1" class="jbm-schedule-form" data-schedule="1">
                <div class="bmp-form-group">
                    <label class="bmp-toggle-label">
                        <input type="checkbox" id="schedule-1-enabled" name="enabled" <?php checked($schedule_1['enabled'], true); ?>>
                        <span class="bmp-toggle-slider"></span>
                        <?php _e('Zeitplan 1 aktivieren', 'jenva-backup-migration'); ?>
                    </label>
                </div>

                <div id="schedule-1-options" class="schedule-options" style="<?php echo $schedule_1['enabled'] ? '' : 'display: none;'; ?>">
                    <div class="bmp-form-row">
                        <div class="bmp-form-group">
                            <label for="schedule-1-frequency">
                                <span class="dashicons dashicons-backup"></span>
                                <?php _e('Häufigkeit', 'jenva-backup-migration'); ?>
                            </label>
                            <select id="schedule-1-frequency" name="frequency" class="bmp-select schedule-frequency">
                                <option value="hourly" <?php selected($schedule_1['frequency'], 'hourly'); ?>><?php _e('⏱️ Stündlich', 'jenva-backup-migration'); ?></option>
                                <option value="daily" <?php selected($schedule_1['frequency'], 'daily'); ?>><?php _e('📅 Täglich', 'jenva-backup-migration'); ?></option>
                                <option value="weekly" <?php selected($schedule_1['frequency'], 'weekly'); ?>><?php _e('📆 Wöchentlich', 'jenva-backup-migration'); ?></option>
                                <option value="monthly" <?php selected($schedule_1['frequency'], 'monthly'); ?>><?php _e('🗓️ Monatlich', 'jenva-backup-migration'); ?></option>
                            </select>
                        </div>

                        <div class="bmp-form-group">
                            <label for="schedule-1-backup-type">
                                <span class="dashicons dashicons-database"></span>
                                <?php _e('Backup-Typ', 'jenva-backup-migration'); ?>
                            </label>
                            <select id="schedule-1-backup-type" name="backup_type" class="bmp-select">
                                <option value="database" <?php selected($schedule_1['backup_type'], 'database'); ?>><?php _e('🗄️ Nur Datenbank (Schnell)', 'jenva-backup-migration'); ?></option>
                                <option value="full" <?php selected($schedule_1['backup_type'], 'full'); ?>><?php _e('💾 Vollständig (DB + Dateien)', 'jenva-backup-migration'); ?></option>
                                <option value="files-only" <?php selected($schedule_1['backup_type'], 'files-only'); ?>><?php _e('📁 Nur Dateien', 'jenva-backup-migration'); ?></option>
                                <option value="plugins" <?php selected($schedule_1['backup_type'], 'plugins'); ?>><?php _e('🔌 Nur Plugins', 'jenva-backup-migration'); ?></option>
                                <option value="themes" <?php selected($schedule_1['backup_type'], 'themes'); ?>><?php _e('🎨 Nur Themes', 'jenva-backup-migration'); ?></option>
                                <option value="uploads" <?php selected($schedule_1['backup_type'], 'uploads'); ?>><?php _e('🖼️ Nur Uploads', 'jenva-backup-migration'); ?></option>
                            </select>
                        </div>
                    </div>

                    <!-- Zeitauswahl (nicht für stündlich) -->
                    <div class="bmp-form-group schedule-time-group" style="<?php echo $schedule_1['frequency'] === 'hourly' ? 'display: none;' : ''; ?>">
                        <label for="schedule-1-time">
                            <span class="dashicons dashicons-clock"></span>
                            <?php _e('Uhrzeit', 'jenva-backup-migration'); ?>
                        </label>
                        <input type="time" id="schedule-1-time" name="time" value="<?php echo esc_attr($schedule_1['time']); ?>" class="bmp-input" style="max-width: 200px;">
                        <p class="bmp-form-help"><?php _e('Wann soll das Backup erstellt werden?', 'jenva-backup-migration'); ?></p>
                    </div>

                    <!-- Wochentag-Auswahl (nur für wöchentlich) -->
                    <div class="bmp-form-group schedule-weekday-group" style="<?php echo $schedule_1['frequency'] === 'weekly' ? '' : 'display: none;'; ?>">
                        <label for="schedule-1-weekday">
                            <span class="dashicons dashicons-calendar-alt"></span>
                            <?php _e('Wochentag', 'jenva-backup-migration'); ?>
                        </label>
                        <select id="schedule-1-weekday" name="weekday" class="bmp-select" style="max-width: 300px;">
                            <option value="1" <?php selected($schedule_1['weekday'], '1'); ?>><?php _e('Montag', 'jenva-backup-migration'); ?></option>
                            <option value="2" <?php selected($schedule_1['weekday'], '2'); ?>><?php _e('Dienstag', 'jenva-backup-migration'); ?></option>
                            <option value="3" <?php selected($schedule_1['weekday'], '3'); ?>><?php _e('Mittwoch', 'jenva-backup-migration'); ?></option>
                            <option value="4" <?php selected($schedule_1['weekday'], '4'); ?>><?php _e('Donnerstag', 'jenva-backup-migration'); ?></option>
                            <option value="5" <?php selected($schedule_1['weekday'], '5'); ?>><?php _e('Freitag', 'jenva-backup-migration'); ?></option>
                            <option value="6" <?php selected($schedule_1['weekday'], '6'); ?>><?php _e('Samstag', 'jenva-backup-migration'); ?></option>
                            <option value="0" <?php selected($schedule_1['weekday'], '0'); ?>><?php _e('Sonntag', 'jenva-backup-migration'); ?></option>
                        </select>
                        <p class="bmp-form-help"><?php _e('An welchem Wochentag soll das Backup erstellt werden?', 'jenva-backup-migration'); ?></p>
                    </div>

                    <!-- Monatstag-Auswahl (nur für monatlich) -->
                    <div class="bmp-form-group schedule-monthday-group" style="<?php echo $schedule_1['frequency'] === 'monthly' ? '' : 'display: none;'; ?>">
                        <label for="schedule-1-monthday">
                            <span class="dashicons dashicons-calendar"></span>
                            <?php _e('Tag des Monats', 'jenva-backup-migration'); ?>
                        </label>
                        <select id="schedule-1-monthday" name="monthday" class="bmp-select" style="max-width: 200px;">
                            <?php for ($i = 1; $i <= 28; $i++): ?>
                                <option value="<?php echo $i; ?>" <?php selected($schedule_1['monthday'], $i); ?>><?php echo $i; ?>.</option>
                            <?php endfor; ?>
                        </select>
                        <p class="bmp-form-help"><?php _e('An welchem Tag des Monats? (Max. 28 für alle Monate)', 'jenva-backup-migration'); ?></p>
                    </div>
                </div>

                <div class="bmp-form-actions">
                    <button type="submit" class="bmp-button bmp-button-primary">
                        <span class="dashicons dashicons-saved"></span>
                        <?php _e('Zeitplan 1 speichern', 'jenva-backup-migration'); ?>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Zeitplan 2 -->
    <div class="bmp-card">
        <div class="bmp-card-header" style="background: linear-gradient(135deg, #00a32a, #00d084);">
            <h2 style="color: white;">
                <span class="dashicons dashicons-clock" style="color: white;"></span>
                <?php _e('Zeitplan 2 - z.B. Wöchentliche Vollständige Backups', 'jenva-backup-migration'); ?>
            </h2>
        </div>
        <div class="bmp-card-body">
            <form id="jbm-schedule-form-2" class="jbm-schedule-form" data-schedule="2">
                <div class="bmp-form-group">
                    <label class="bmp-toggle-label">
                        <input type="checkbox" id="schedule-2-enabled" name="enabled" <?php checked($schedule_2['enabled'], true); ?>>
                        <span class="bmp-toggle-slider"></span>
                        <?php _e('Zeitplan 2 aktivieren', 'jenva-backup-migration'); ?>
                    </label>
                </div>

                <div id="schedule-2-options" class="schedule-options" style="<?php echo $schedule_2['enabled'] ? '' : 'display: none;'; ?>">
                    <div class="bmp-form-row">
                        <div class="bmp-form-group">
                            <label for="schedule-2-frequency">
                                <span class="dashicons dashicons-backup"></span>
                                <?php _e('Häufigkeit', 'jenva-backup-migration'); ?>
                            </label>
                            <select id="schedule-2-frequency" name="frequency" class="bmp-select schedule-frequency">
                                <option value="hourly" <?php selected($schedule_2['frequency'], 'hourly'); ?>><?php _e('⏱️ Stündlich', 'jenva-backup-migration'); ?></option>
                                <option value="daily" <?php selected($schedule_2['frequency'], 'daily'); ?>><?php _e('📅 Täglich', 'jenva-backup-migration'); ?></option>
                                <option value="weekly" <?php selected($schedule_2['frequency'], 'weekly'); ?>><?php _e('📆 Wöchentlich', 'jenva-backup-migration'); ?></option>
                                <option value="monthly" <?php selected($schedule_2['frequency'], 'monthly'); ?>><?php _e('🗓️ Monatlich', 'jenva-backup-migration'); ?></option>
                            </select>
                        </div>

                        <div class="bmp-form-group">
                            <label for="schedule-2-backup-type">
                                <span class="dashicons dashicons-database"></span>
                                <?php _e('Backup-Typ', 'jenva-backup-migration'); ?>
                            </label>
                            <select id="schedule-2-backup-type" name="backup_type" class="bmp-select">
                                <option value="full" <?php selected($schedule_2['backup_type'], 'full'); ?>><?php _e('💾 Vollständig (DB + Dateien)', 'jenva-backup-migration'); ?></option>
                                <option value="database" <?php selected($schedule_2['backup_type'], 'database'); ?>><?php _e('🗄️ Nur Datenbank (Schnell)', 'jenva-backup-migration'); ?></option>
                                <option value="files-only" <?php selected($schedule_2['backup_type'], 'files-only'); ?>><?php _e('📁 Nur Dateien', 'jenva-backup-migration'); ?></option>
                                <option value="plugins" <?php selected($schedule_2['backup_type'], 'plugins'); ?>><?php _e('🔌 Nur Plugins', 'jenva-backup-migration'); ?></option>
                                <option value="themes" <?php selected($schedule_2['backup_type'], 'themes'); ?>><?php _e('🎨 Nur Themes', 'jenva-backup-migration'); ?></option>
                                <option value="uploads" <?php selected($schedule_2['backup_type'], 'uploads'); ?>><?php _e('🖼️ Nur Uploads', 'jenva-backup-migration'); ?></option>
                            </select>
                        </div>
                    </div>

                    <!-- Zeitauswahl (nicht für stündlich) -->
                    <div class="bmp-form-group schedule-time-group" style="<?php echo $schedule_2['frequency'] === 'hourly' ? 'display: none;' : ''; ?>">
                        <label for="schedule-2-time">
                            <span class="dashicons dashicons-clock"></span>
                            <?php _e('Uhrzeit', 'jenva-backup-migration'); ?>
                        </label>
                        <input type="time" id="schedule-2-time" name="time" value="<?php echo esc_attr($schedule_2['time']); ?>" class="bmp-input" style="max-width: 200px;">
                        <p class="bmp-form-help"><?php _e('Wann soll das Backup erstellt werden?', 'jenva-backup-migration'); ?></p>
                    </div>

                    <!-- Wochentag-Auswahl (nur für wöchentlich) -->
                    <div class="bmp-form-group schedule-weekday-group" style="<?php echo $schedule_2['frequency'] === 'weekly' ? '' : 'display: none;'; ?>">
                        <label for="schedule-2-weekday">
                            <span class="dashicons dashicons-calendar-alt"></span>
                            <?php _e('Wochentag', 'jenva-backup-migration'); ?>
                        </label>
                        <select id="schedule-2-weekday" name="weekday" class="bmp-select" style="max-width: 300px;">
                            <option value="1" <?php selected($schedule_2['weekday'], '1'); ?>><?php _e('Montag', 'jenva-backup-migration'); ?></option>
                            <option value="2" <?php selected($schedule_2['weekday'], '2'); ?>><?php _e('Dienstag', 'jenva-backup-migration'); ?></option>
                            <option value="3" <?php selected($schedule_2['weekday'], '3'); ?>><?php _e('Mittwoch', 'jenva-backup-migration'); ?></option>
                            <option value="4" <?php selected($schedule_2['weekday'], '4'); ?>><?php _e('Donnerstag', 'jenva-backup-migration'); ?></option>
                            <option value="5" <?php selected($schedule_2['weekday'], '5'); ?>><?php _e('Freitag', 'jenva-backup-migration'); ?></option>
                            <option value="6" <?php selected($schedule_2['weekday'], '6'); ?>><?php _e('Samstag', 'jenva-backup-migration'); ?></option>
                            <option value="0" <?php selected($schedule_2['weekday'], '0'); ?>><?php _e('Sonntag', 'jenva-backup-migration'); ?></option>
                        </select>
                        <p class="bmp-form-help"><?php _e('An welchem Wochentag soll das Backup erstellt werden?', 'jenva-backup-migration'); ?></p>
                    </div>

                    <!-- Monatstag-Auswahl (nur für monatlich) -->
                    <div class="bmp-form-group schedule-monthday-group" style="<?php echo $schedule_2['frequency'] === 'monthly' ? '' : 'display: none;'; ?>">
                        <label for="schedule-2-monthday">
                            <span class="dashicons dashicons-calendar"></span>
                            <?php _e('Tag des Monats', 'jenva-backup-migration'); ?>
                        </label>
                        <select id="schedule-2-monthday" name="monthday" class="bmp-select" style="max-width: 200px;">
                            <?php for ($i = 1; $i <= 28; $i++): ?>
                                <option value="<?php echo $i; ?>" <?php selected($schedule_2['monthday'], $i); ?>><?php echo $i; ?>.</option>
                            <?php endfor; ?>
                        </select>
                        <p class="bmp-form-help"><?php _e('An welchem Tag des Monats? (Max. 28 für alle Monate)', 'jenva-backup-migration'); ?></p>
                    </div>
                </div>

                <div class="bmp-form-actions">
                    <button type="submit" class="bmp-button bmp-button-primary">
                        <span class="dashicons dashicons-saved"></span>
                        <?php _e('Zeitplan 2 speichern', 'jenva-backup-migration'); ?>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Empfohlene Konfigurationen -->
    <div style="margin: 20px 0; padding: 15px; background: #e7f5ff; border-left: 4px solid #2271b1; border-radius: 6px;">
        <h3 style="margin: 0 0 10px 0; font-size: 15px; color: #135e96;">
            <?php _e('💡 Empfohlene Zeitplan-Kombinationen', 'jenva-backup-migration'); ?>
        </h3>
        <div style="font-size: 13px; color: #135e96; line-height: 1.8;">
            <strong><?php _e('🏢 Für kleine Websites:', 'jenva-backup-migration'); ?></strong><br>
            <?php echo sprintf(__('• Zeitplan 1: Täglich um 2:00 Uhr → Datenbank', 'jenva-backup-migration')); ?><br>
            <?php echo sprintf(__('• Zeitplan 2: Wöchentlich Sonntag 3:00 Uhr → Vollständig', 'jenva-backup-migration')); ?><br><br>
            
            <strong><?php _e('🏪 Für E-Commerce/Shops:', 'jenva-backup-migration'); ?></strong><br>
            <?php echo sprintf(__('• Zeitplan 1: Stündlich → Datenbank (bei häufigen Bestellungen)', 'jenva-backup-migration')); ?><br>
            <?php echo sprintf(__('• Zeitplan 2: Täglich um 3:00 Uhr → Vollständig', 'jenva-backup-migration')); ?><br><br>
            
            <strong><?php _e('📰 Für Blogs/News-Seiten:', 'jenva-backup-migration'); ?></strong><br>
            <?php echo sprintf(__('• Zeitplan 1: Täglich um 1:00 Uhr → Datenbank', 'jenva-backup-migration')); ?><br>
            <?php echo sprintf(__('• Zeitplan 2: Wöchentlich Montag 2:00 Uhr → Uploads', 'jenva-backup-migration')); ?><br>
        </div>
    </div>

    <!-- Debug: WordPress Cron Status -->
    <?php if ($show_cron_debug): ?>
    <div class="bmp-card">
        <div class="bmp-card-header">
            <h2><?php _e('🔍 Cron-Status & Debugging', 'jenva-backup-migration'); ?></h2>
        </div>
        <div class="bmp-card-body">
            <?php
            // Alle geplanten Events anzeigen
            $cron_events = _get_cron_array();
            $our_events = [];
            
            foreach ($cron_events as $timestamp => $events) {
                foreach ($events as $hook => $event_data) {
                    if (strpos($hook, 'jbm_scheduled_backup') !== false) {
                        $our_events[] = [
                            'hook' => $hook,
                            'timestamp' => $timestamp,
                            'time' => date_i18n('Y-m-d H:i:s', $timestamp),
                            'args' => $event_data
                        ];
                    }
                }
            }
            ?>
            
            <div style="background: #f6f7f7; padding: 15px; border-radius: 6px; font-family: monospace; font-size: 12px;">
                <strong style="display: block; margin-bottom: 10px; font-size: 14px; color: #1d2327;">
                    <?php _e('WordPress Cron Events für dieses Plugin:', 'jenva-backup-migration'); ?>
                </strong>
                
                <?php if (empty($our_events)): ?>
                    <div style="padding: 15px; background: #fee; border-radius: 4px; border-left: 3px solid #d63638;">
                        <p style="color: #d63638; margin: 0; font-weight: bold;">
                            <?php _e('❌ Keine Cron-Events gefunden!', 'jenva-backup-migration'); ?>
                        </p>
                        <p style="margin: 10px 0 0 0; font-size: 12px; color: #646970;">
                            <?php _e('Mögliche Ursachen:', 'jenva-backup-migration'); ?>
                        </p>
                        <ul style="margin: 5px 0 0 20px; font-size: 11px; color: #646970;">
                            <li><?php _e('Zeitplan wurde noch nicht gespeichert', 'jenva-backup-migration'); ?></li>
                            <li><?php _e('Zeitplan ist deaktiviert (Checkbox nicht aktiv)', 'jenva-backup-migration'); ?></li>
                            <li><?php _e('WordPress Cron-System hat ein Problem', 'jenva-backup-migration'); ?></li>
                            <li><?php _e('Schedule-Klasse wird nicht korrekt geladen', 'jenva-backup-migration'); ?></li>
                        </ul>
                        
                        <?php
                        // Zusatz-Debug: Prüfe ob Schedule-Klasse existiert
                        if (class_exists('\JBM\Schedule')) {
                            echo "<p style='color: #00a32a; margin-top: 10px;'>✅ " . __('Schedule-Klasse ist geladen', 'jenva-backup-migration') . "</p>";
                        } else {
                            echo "<p style='color: #d63638; margin-top: 10px;'>❌ " . __('Schedule-Klasse NICHT geladen!', 'jenva-backup-migration') . "</p>";
                        }
                        
                        // Prüfe ob Custom Schedules registriert sind
                        $wp_schedules = wp_get_schedules();
                        if (isset($wp_schedules['weekly']) && isset($wp_schedules['monthly'])) {
                            echo "<p style='color: #00a32a;'>✅ " . __('Custom Schedules (weekly, monthly) sind registriert', 'jenva-backup-migration') . "</p>";
                        } else {
                            echo "<p style='color: #d63638;'>❌ " . __('Custom Schedules NICHT registriert!', 'jenva-backup-migration') . "</p>";
                        }
                        
                        // Zeige gespeicherte Zeitplan-Daten
                        $saved_schedule_1 = get_option('jbm_schedule_1');
                        $saved_schedule_2 = get_option('jbm_schedule_2');
                        
                        if ($saved_schedule_1 || $saved_schedule_2) {
                            echo "<p style='margin-top: 10px; font-weight: bold;'>" . __('Gespeicherte Zeitpläne:', 'jenva-backup-migration') . "</p>";
                            if ($saved_schedule_1) {
                                echo "<div style='background: white; padding: 8px; border-radius: 4px; margin: 5px 0;'>";
                                echo "<strong>" . __('Zeitplan 1:', 'jenva-backup-migration') . "</strong> " . ($saved_schedule_1['enabled'] ? __('✅ Aktiv', 'jenva-backup-migration') : __('❌ Inaktiv', 'jenva-backup-migration'));
                                echo " | " . __('Typ:', 'jenva-backup-migration') . " " . $saved_schedule_1['backup_type'];
                                echo " | " . __('Frequenz:', 'jenva-backup-migration') . " " . $saved_schedule_1['frequency'];
                                echo "</div>";
                            }
                            if ($saved_schedule_2) {
                                echo "<div style='background: white; padding: 8px; border-radius: 4px; margin: 5px 0;'>";
                                echo "<strong>" . __('Zeitplan 2:', 'jenva-backup-migration') . "</strong> " . ($saved_schedule_2['enabled'] ? __('✅ Aktiv', 'jenva-backup-migration') : __('❌ Inaktiv', 'jenva-backup-migration'));
                                echo " | " . __('Typ:', 'jenva-backup-migration') . " " . $saved_schedule_2['backup_type'];
                                echo " | " . __('Frequenz:', 'jenva-backup-migration') . " " . $saved_schedule_2['frequency'];
                                echo "</div>";
                            }
                        }
                        ?>
                    </div>
                <?php else: ?>
                    <?php foreach ($our_events as $event): ?>
                        <div style="margin-bottom: 10px; padding: 10px; background: white; border-radius: 4px; border-left: 3px solid #2271b1;">
                            <strong><?php echo esc_html($event['hook']); ?></strong><br>
                            <?php _e('Nächste Ausführung:', 'jenva-backup-migration'); ?> <span style="color: #00a32a;"><?php echo $event['time']; ?></span><br>
                            <?php _e('Timestamp:', 'jenva-backup-migration'); ?> <?php echo $event['timestamp']; ?><br>
                            <?php _e('In:', 'jenva-backup-migration'); ?> <strong><?php echo human_time_diff($event['timestamp'], time()); ?></strong><br>
                            <?php _e('Args:', 'jenva-backup-migration'); ?> <pre style="margin: 5px 0 0 0; font-size: 11px;"><?php print_r($event['args']); ?></pre>
                        </div>
                    <?php endforeach; ?>
                    <p style="color: #00a32a; font-weight: bold; margin-top: 15px;">
                        <?php _e('✅ Zeitpläne sind aktiv und werden ausgeführt!', 'jenva-backup-migration'); ?>
                    </p>
                <?php endif; ?>
                
                <div style="margin-top: 15px; padding: 10px; background: #e7f5ff; border-radius: 4px;">
                    <strong style="color: #135e96;">ℹ️ <?php _e('Hinweise:', 'jenva-backup-migration'); ?></strong>
                    <ul style="margin: 8px 0 0 20px; color: #135e96; font-size: 11px; line-height: 1.6;">
                        <li><?php _e('WordPress Cron läuft nur wenn Ihre Seite besucht wird', 'jenva-backup-migration'); ?></li>
                        <li><?php _e('Bei wenig Traffic: Echten Server-Cron nutzen', 'jenva-backup-migration'); ?></li>
                        <li><?php _e('Wenn keine Events sichtbar sind, Zeitplan neu speichern', 'jenva-backup-migration'); ?></li>
                    </ul>
                </div>
                
                <!-- Manueller Test-Button -->
                <div style="margin-top: 15px; padding: 15px; background: #fff3cd; border-radius: 4px; border: 1px solid #ffc107;">
                    <strong style="color: #856404;"><?php _e('🧪 Manuelle Zeitplan-Ausführung (Test):', 'jenva-backup-migration'); ?></strong>
                    <p style="margin: 8px 0; color: #856404; font-size: 12px;">
                        <?php _e('Führt das geplante Backup sofort aus, ohne auf den Zeitplan zu warten. Ideal zum Testen ob die Zeitplan-Logik funktioniert.', 'jenva-backup-migration'); ?>
                    </p>
                    <button id="bmp-test-schedule-1" class="bmp-button bmp-button-primary" style="margin: 5px 5px 0 0;">
                        <?php _e('🧪 Zeitplan 1 jetzt ausführen', 'jenva-backup-migration'); ?>
                    </button>
                    <button id="bmp-test-schedule-2" class="bmp-button bmp-button-success" style="margin: 5px 0 0 0;">
                        <?php _e('🧪 Zeitplan 2 jetzt ausführen', 'jenva-backup-migration'); ?>
                    </button>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Backup-Historie -->
    <div class="bmp-card">
        <div class="bmp-card-header">
            <h2><?php _e('Geplante Backup-Historie', 'jenva-backup-migration'); ?></h2>
        </div>
        <div class="bmp-card-body">
            <?php
            global $wpdb;
            $table_name = $wpdb->prefix . 'jbm_backups';
            $scheduled_backups = $wpdb->get_results(
                "SELECT * FROM $table_name WHERE backup_name LIKE '%scheduled%' ORDER BY backup_date DESC LIMIT 20"
            );
            ?>
            
            <?php if (empty($scheduled_backups)): ?>
                <div class="bmp-empty-state">
                    <span class="dashicons dashicons-clock"></span>
                    <h3><?php _e('Keine geplanten Backups', 'jenva-backup-migration'); ?></h3>
                    <p><?php _e('Es wurden noch keine geplanten Backups erstellt.', 'jenva-backup-migration'); ?></p>
                </div>
            <?php else: ?>
                <div class="bmp-timeline">
                    <?php foreach ($scheduled_backups as $backup): ?>
                        <div class="bmp-timeline-item">
                            <div class="bmp-timeline-marker"></div>
                            <div class="bmp-timeline-content">
                                <h4><?php echo esc_html($backup->backup_name); ?></h4>
                                <p class="bmp-timeline-date">
                                    <?php echo date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime($backup->backup_date)); ?>
                                </p>
                                <div class="bmp-timeline-meta">
                                    <span><?php _e('Typ:', 'jenva-backup-migration'); ?> <?php echo esc_html($backup->backup_type); ?></span>
                                    <span><?php _e('Größe:', 'jenva-backup-migration'); ?> <?php echo size_format($backup->backup_size); ?></span>
                                    <span class="bmp-status-badge bmp-status-success"><?php _e('Erfolgreich', 'jenva-backup-migration'); ?></span>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
jQuery(document).ready(function($) {
    // Funktion zum Aktualisieren der Sichtbarkeit basierend auf Frequenz
    function updateFrequencyFields(form) {
        const frequency = form.find('.schedule-frequency').val();
        
        // Zeit ausblenden bei stündlich
        if (frequency === 'hourly') {
            form.find('.schedule-time-group').hide();
        } else {
            form.find('.schedule-time-group').show();
        }
        
        // Wochentag nur bei wöchentlich
        if (frequency === 'weekly') {
            form.find('.schedule-weekday-group').show();
        } else {
            form.find('.schedule-weekday-group').hide();
        }
        
        // Monatstag nur bei monatlich
        if (frequency === 'monthly') {
            form.find('.schedule-monthday-group').show();
        } else {
            form.find('.schedule-monthday-group').hide();
        }
    }
    
    // Initialisierung beim Seitenladen
    $('.jbm-schedule-form').each(function() {
        updateFrequencyFields($(this));
    });
    
    // Dynamische Felder basierend auf Frequenz ein/ausblenden
    $('.schedule-frequency').on('change', function() {
        const form = $(this).closest('.jbm-schedule-form');
        updateFrequencyFields(form);
    });
    
    // Optionen ein/ausblenden basierend auf Checkbox
    $('#schedule-1-enabled').on('change', function() {
        $('#schedule-1-options').toggle(this.checked);
    });
    
    $('#schedule-2-enabled').on('change', function() {
        $('#schedule-2-options').toggle(this.checked);
    });
    
    // Test-Buttons für manuelle Ausführung
    $('#bmp-test-schedule-1, #bmp-test-schedule-2').on('click', function() {
        const scheduleNum = $(this).attr('id') === 'bmp-test-schedule-1' ? 1 : 2;
        
        if (!confirm(jbmAdmin.strings.test_schedule_confirm.replace('%d', scheduleNum))) {
            return;
        }
        
        const button = $(this);
        const originalText = button.text();
        button.prop('disabled', true).text(jbmAdmin.strings.creating);
        
        $.ajax({
            url: jbmAdmin.ajaxUrl,
            type: 'POST',
            data: {
                action: 'jbm_test_schedule',
                nonce: jbmAdmin.nonce,
                schedule_num: scheduleNum
            },
            success: function(response) {
                console.log('Test-Schedule Response:', response);
                
                if (response.success) {
                    // Erfolgsmeldung anzeigen
                    $('<div style="position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); background: white; padding: 30px; border-radius: 12px; box-shadow: 0 8px 32px rgba(0,0,0,0.3); z-index: 999999; text-align: center;">' +
                        '<div style="font-size: 48px; margin-bottom: 15px;">✅</div>' +
                        '<h3 style="margin: 0 0 10px 0; color: #00a32a;">Backup erfolgreich erstellt!</h3>' +
                        '<p style="margin: 0; color: #646970;">' + response.data.message.replace(/\n/g, '<br>') + '</p>' +
                        '<p style="margin: 15px 0 0 0; color: #2271b1; font-size: 13px;">Weiterleitung zur Backup-Liste...</p>' +
                        '</div>').appendTo('body');
                    
                    // Weiterleitung nach 2 Sekunden
                    setTimeout(function() {
                        window.location.href = 'admin.php?page=jenva-backup-migration';
                    }, 2000);
                } else {
                    alert('❌ Fehler!\n\n' + (response.data.message || 'Unbekannter Fehler'));
                    button.prop('disabled', false).text(originalText);
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX-Fehler:', xhr, status, error);
                console.error('Response Text:', xhr.responseText);
                alert(jbmAdmin.strings.ajax_error.replace('%s', error).replace('%s', status).replace('%s', (xhr.responseText ? xhr.responseText.substring(0, 200) : jbmAdmin.strings.empty || 'Empty')));
                button.prop('disabled', false).text(originalText);
            }
        });
    });
    
    // Zeitplan-Formulare per AJAX speichern
    $('.jbm-schedule-form').on('submit', function(e) {
        e.preventDefault();
        
        const form = $(this);
        const scheduleNum = form.data('schedule');
        const button = form.find('button[type="submit"]');
        
        button.prop('disabled', true);
        
        const scheduleData = {
            action: 'jbm_save_schedule',
            nonce: jbmAdmin.nonce,
            schedule_num: scheduleNum,
            enabled: form.find('[name="enabled"]').is(':checked'),
            frequency: form.find('[name="frequency"]').val(),
            time: form.find('[name="time"]').val(),
            weekday: form.find('[name="weekday"]').val(),
            monthday: form.find('[name="monthday"]').val(),
            backup_type: form.find('[name="backup_type"]').val()
        };
        
        console.log('Speichere Zeitplan ' + scheduleNum + ':', scheduleData);
        
        $.ajax({
            url: jbmAdmin.ajaxUrl,
            type: 'POST',
            data: scheduleData,
            success: function(response) {
                console.log('Zeitplan-Response:', response);
                
                if (response.success) {
                    // Success notification
                    $('<div class="bmp-alert bmp-alert-success" style="position: fixed; top: 32px; right: 20px; z-index: 999999; animation: slideInRight 0.3s ease; box-shadow: 0 4px 16px rgba(0,0,0,0.15);">' +
                        '<span class="dashicons dashicons-yes"></span>' +
                        '<div>' + response.data.message + '</div>' +
                        '</div>').appendTo('body').delay(3000).fadeOut(300, function() {
                            $(this).remove();
                            location.reload(); // Reload um nächste Backup-Zeiten anzuzeigen
                        });
                } else {
                    console.error('Zeitplan-Fehler:', response);
                    alert('Fehler: ' + (response.data.message || 'Unbekannter Fehler'));
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX-Fehler:', xhr, status, error);
                alert(jbmAdmin.strings.save_schedule_error.replace('%s', error).replace('%s', status));
            },
            complete: function() {
                button.prop('disabled', false);
            }
        });
    });
});
</script>
